
$ = ($ || jQuery);

$(document).ready(function(){
    
    //var questions_carousel = $('#myCarousel');
    var loading_overlay = $('.loading-layer');
   
    /* START: Answer question handler */
    
    $(document).on('click', '.answer-trigger', function(evt){
        
        evt.preventDefault();
        
        var me = $(this);
        var answer_input = me.parent().find('.inputable.question-answer');
        
        var answer_content = answer_input.val();
        var answer_key = answer_input.data('answer-key');
        
        if(!answer_content){
            answer_input.css({
                'border-color' : '#d30202'
            });
    
            return;
        }
        
        me.prop('disabled', true);
        
        //questions_carousel.carousel('pause');
        
        loading_overlay.removeClass('error');
        loading_overlay.addClass('active');
        
        $.ajax({
            url: '/ajax/ajax.action.php',
            method: "POST",
            data: {
                'answer_key': answer_key,
                'answer_content': answer_content,
                'mode': 'question_answer'
            },
            success: function(raw_response){
                
                me.prop('disabled', false);
                $('.btnlink.get_next_question').remove();
                
                try{
                    var response = $.parseJSON(raw_response);
                    
                    if(response.hasOwnProperty('type') && response.type == 'success'){
                        
                        loading_overlay.removeClass('active');
                        answer_input.parent().find('.answer-feedback').removeClass('correct');
                        answer_input.parent().find('.answer-feedback').removeClass('wrong');
                        answer_input.parent().find('.answer-feedback').addClass( ( (response.data == 1) ? "correct" : "wrong" ) );
                        
                        answer_input.parent().find('.answer-text-feedback').removeClass('correct');
                        answer_input.parent().find('.answer-text-feedback').removeClass('wrong');
                        answer_input.parent().find('.answer-text-feedback').html( ( (response.data == 1) ? "Dobra odpowiedź" : "Twoja odpowiedź jest błędna" ) ).addClass( ( (response.data == 1) ? "correct" : "wrong" ) );
                        
                        //perform special actions if anwer is correct
                        if(response.data == 1){
                            
                            $('.hero-unit').append("<a href='#' class='btnlink get_next_question'>Następne pytanie&nbsp;&rsaquo;</a>");
                            
                        }
                        
                    }
                    else{
                        
                        loading_overlay.addClass('error');
                        loading_overlay.html('<p>Twoja odpowiedź nie została zapisana, ponieważ system napotkał błąd: ' + response.data + '</p>');
                        
                    }
                    
                }
                catch(ex){
                    loading_overlay.addClass('error');
                    loading_overlay.html('<p>Napotkano błąd podczas interpretacji odpowiedzi</p>');
                }
                
            }
        });
        
    });
    
    /* END: Answer question handler */
    
    /* START: Get next question */
    
    $(document).on('click', '.get_next_question', function(evt){
        
        evt.preventDefault();
        
        var me = $(this);
        var answer_input = $('.inputable.question-answer');
        
        loading_overlay.addClass('active');
        
        $.ajax({
            url: '/ajax/ajax.action.php',
            method: 'POST',
            data: { 
                'answer_key' : answer_input.data('answer-key'),
                'mode' : 'get_next_question'
            },
            success: function(raw_response){
                
                try{
                    var response = $.parseJSON(raw_response);
                    
                    if(response.hasOwnProperty('type') && response.type == 'success'){
                        
                        loading_overlay.removeClass('active');
                        $('.answer-feedback').removeClass('correct');
                        $('.answer-text-feedback').removeClass("correct");
                        $('.get_next_question').remove();
                        
                        if(response.data.hasOwnProperty('title') && response.data.hasOwnProperty('akey')){
                            $('.question_content').html( response.data.title );
                            $('.inputable.question-answer').val('');
                            var r_k = $('.inputable.question-answer').data('answer-key');
                            $('.inputable.question-answer').data('answer-key', response.data.akey);
                        }
                        else{ //has answered for all questions
                            $('.hero-unit').find('h3').html('Gratulacje');
                            $('.carousel-inner').remove();
                            $('#myCarousel').html("<p class='correct'>Odpowiedziałeś poprawnie na wszystkie pytania.</p>");
                            $('.hero-unit').addClass('hero_win');
                        }
                    }
                    else{
                        
                        loading_overlay.addClass('error');
                        loading_overlay.html('<p>Twoja odpowiedź nie została zapisana, ponieważ system napotkał błąd: ' + response.data + '</p>');
                        
                    }
                    
                }
                catch(ex){
                    loading_overlay.addClass('error');
                    loading_overlay.html('<p>Napotkano błąd podczas interpretacji odpowiedzi</p>');
                }
                
            }
        });
        
    });
    
    /* END: Get next question */
    
    $.ajaxSetup({ 
        cache: false 
    });
   
    $(document).ajaxError(function(event, xhr_object, settings, error_message){
        console.log("Wystąpił błąd przy dostarczaniu żądania: " + error_message);
    });
    
});